<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Admin;

use Erlage\Photogram\Data\Dtos\AbstractDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintValidatorDTO;
use Erlage\Photogram\Data\Dtos\Traits\TraitComplaintTransformerDTO;

class AdminSettingSaveResultsDTO extends AbstractDTO
{
    /**
     * to comply with DTO interface
     */
    use TraitComplaintValidatorDTO;
    use TraitComplaintTransformerDTO;

    const DTO_NAME = 'admin_setting_save_results_dto';

    /*
    |--------------------------------------------------------------------------
    | key map
    |--------------------------------------------------------------------------
    */

    const KEY_RESULT_TYPE = 'result_type';

    const KEY_SETTING_KEY = 'setting_key';

    const KEY_MESSAGE = 'message';

    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string
     */
    private $resultType;

    /**
     * @property string
     */
    private $settingKey;

    /**
     * @var string
     */
    private $message;

    /**
     * @return static 
     */
    public function setResultType(string $resultType)
    {
        $this -> resultType = $resultType;

        return $this;
    }

    /**
     * @return static 
     */
    public function setSettingKey(string $settingKey)
    {
        $this -> settingKey = $settingKey;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMessage(string $message)
    {
        $this -> message = $message;

        return $this;
    }

    /*
    |--------------------------------------------------------------------------
    | from json
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return (new static())
            -> setResultType((string) $data[self::KEY_RESULT_TYPE])
            -> setSettingKey((string) $data[self::KEY_SETTING_KEY])
            -> setMessage((string) $data[self::KEY_MESSAGE]);
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return array(
            self::KEY_RESULT_TYPE         => $this -> resultType,
            self::KEY_SETTING_KEY         => $this -> settingKey,
            self::KEY_MESSAGE             => $this -> message,
        );
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    /**
     * @param AdminSettingSaveResultsDTO $adminSettingSaveResultsDTO
     */
    public static function serialize($adminSettingSaveResultsDTO): string
    {
        return \json_encode($adminSettingSaveResultsDTO);
    }

    /**
     * @return AdminSettingSaveResultsDTO
     */
    public static function deSerialize(string $adminSettingSaveResultsDTO)
    {
        $data = \json_decode($adminSettingSaveResultsDTO, true);

        return static::fromJsonMap($data);
    }
}
